class Result_collection:
    def __init__(self, k_values, subset_sizes, n_runs, dataset_name, algo_name, j = None, z = None):
        self.k_values = k_values
        self.algo_name = algo_name
        self.subset_sizes = subset_sizes
        self.n_runs = n_runs
        self.dataset_name = dataset_name
        self.results = {}
        self.j = j
        self.z = z
    def get_file_name(self):
        file_name = f"{self.algo_name}_{self.dataset_name}_{self.j if (self.j is not None) else ''}_{self.z if (self.z is not None) else ''}"    
        return file_name
    def add_result(self, run_result):
        self.results[(run_result.k, run_result.subset_size)] = run_result
    
    def get(self, k, subset_size):
        return self.results[(k, subset_size)]

class Run_results:
    def __init__(self, k, subset_size, num_runs):
        self.k = k
        self.subset_size = subset_size
        self.num_runs = num_runs
        self.subset_solution_original = []
        self.centers_full = None
        self.centers_subset = []
        self.original_cost = None
        self.subset_cost = []
        
    #def add_subsetcost(self, cost):
    #    self.subset_cost.append(cost)
        
        
    def add_subset_solution_original(self, solution):
        self.subset_solution_original.append(solution)
    
    def add_centers_subset(self, centers):
        self.centers_subset.append(centers)
    def add_subset_cost(self, cost):
        self.subset_cost.append(cost)
        
    def set_originalcost(self, cost):
        assert self.original_cost is None
        self.original_cost = cost
    
    def set_centers_full(self, centers):
        assert self.centers_full is None
        self.centers_full = centers    
    
    def get_average_subset_solution_original(self):
        assert (len(self.subset_solution_original) == self.num_runs)
        return sum(self.subset_solution_original)/len(self.subset_solution_original)
